<h2><?= $program->name ?></h2>
<h5>Szczegóły programu lojalnościowego</h5>
<ol class="breadcrumb pb-4">
  <li class="breadcrumb-item"><a href="index.php">Programy</a></li>
  <li class="breadcrumb-item active"><?= $program->name ?></li>
</ol>

<div class="row">
  <!-- informacje podstawowe o programie -->
  <div class="col-lg-6">
    <div class="table-responsive">
      <h5 class="text-center mt-4">Szczegóły programu</h5>
      <table class="table table-striped">
        <tbody>
          <? foreach([
            'id' => 'Identyfikator',
            'name' => 'Nazwa',
            'companyName' => 'Organizator',
            'descr' => 'Opis',
            'startPrize' => 'Korzyść powitalna',
            'recommendPoints' => 'Punkty za polecenie',
            'collectPointsTo' => 'Zbieranie punktów do',
            'receivePrizesTo' => 'Odbiór nagród do',
          ] as $var => $name): ?>
          <tr>
            <td><strong><?= $name ?></strong></td>
            <td><?= $program->$var ?></td>
          </tr>
          <? endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- punkty za zakupy -->
  <div class="col-lg-6">
    <div class="table-responsive">
      <h5 class="text-center mt-4">Punkty za zakupy</h5>
      <table class="table table-striped">
        <thead>
          <tr>
            <th>Kod</th>
            <th>Nazwa</th>
            <th>Etykieta</th>
            <th>Opis</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
        <? foreach ($points as $point): ?>
          <tr>
            <td><?= $point->tag ?></td>
            <td><?= $point->name ?></td>
            <td><?= $point->label ?></td>
            <td><?= $point->descr ?></td>
            <td>
              <a class="btn btn-sm btn-primary" href="points.php?program=<?= $program->id ?>&tag=<?= $point->tag ?>">
                przekaż&nbsp;&raquo;
              </button>
            </td>
          </tr>
        <? endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>
</div>

<div class="row">
  <!-- nagrody -->
  <div class="col-lg-8">
    <div class="table-responsive">
      <h5 class="text-center mt-4">Nagrody</h5>
      <table class="table table-striped">
        <thead>
          <tr>
            <th>Kod</th>
            <th>Nazwa</th>
            <th>Etykieta</th>
            <th>Wartość</th>
            <th>Opis</th>
            <th>Dostępność</th>
            <th></th>
          </tr>
        </thead>
        <tbody>
        <? foreach ($prizes as $prize): ?>
          <tr>
            <td><?= $prize->tag ?></td>
            <td><?= $prize->name ?></td>
            <td><?= $prize->label ?></td>
            <td><?= $prize->points ?> pkt</td>
            <td><?= $prize->descr ?></td>
            <td>
              <?= $prize->availableCnt === null ? '99+' : $prize->availableCnt ?>
              <? if ($prize->onlyForSeller) echo '<br />(tylko dla sprzedawcy)' ?>
            </td>
            <td>
              <a class="btn btn-sm btn-primary waiting" href="giveprize.php?program=<?= $program->id ?>&tag=<?= $prize->tag ?>">
                przekaż&nbsp;&raquo;
              </button>
            </td>
          </tr>
        <? endforeach; ?>
        </tbody>
      </table>
    </div>
  </div>

  <!-- odbior nagrody -->
  <div class="col-lg-4 text-center">
    <h5 class="mt-4">Odbiór nagrody</h5>
    <p>
      <a class="btn btn-primary" href="prize.php">odbierz nagrodę &raquo;</a>
    </p>
  </div>
</div>
