<h2>Odbiór nagrody</h2>
<h5>Potwierdzenie odbioru nagrody w programie lojalnościowym</h5>
<ol class="breadcrumb pb-4">
  <li class="breadcrumb-item"><a href="index.php">Programy</a></li>
  <li class="breadcrumb-item active">Odbiór nagrody</li>
</ol>

<div class="row justify-content-center mt-5">
  <div class="col col-md-8 col-lg-6">
    <form action="prize.php">
      <input type="hidden" name="code" value="<?= filter_input(INPUT_GET, 'code', FILTER_SANITIZE_NUMBER_INT) ?>" />
      <input type="hidden" name="confirm" value="1" />
      <div class="card">
        <div class="card-header">
          <h5>Potwierdzenie odbioru nagrody</h5>
        </div>
        <div class="card-body">
          <? if (isset($error)): ?>
            <div class="alert alert-danger d-flex">
              <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" fill="currentColor" class="bi bi-exclamation-triangle-fill flex-shrink-0 me-2" viewBox="0 0 16 16" role="img">
                <path d="M8.982 1.566a1.13 1.13 0 0 0-1.96 0L.165 13.233c-.457.778.091 1.767.98 1.767h13.713c.889 0 1.438-.99.98-1.767L8.982 1.566zM8 5c.535 0 .954.462.9.995l-.35 3.507a.552.552 0 0 1-1.1 0L7.1 5.995A.905.905 0 0 1 8 5zm.002 6a1 1 0 1 1 0 2 1 1 0 0 1 0-2z"/>
              </svg>  
              <div><?= $error ?></div>
            </div>
          <? endif; ?>
          <div class="text-center">
            <h5><?= $result->title ?></h5>
            <h6>w programie <?= $program->name ?>:</h6>
            <p class="alert alert-secondary"><?= $result->descr ?></p>
            <p>Do odbioru nagrody zostało <b id="timeout"></b> sekund</p>
          </div>
        </div>
        <div class="card-footer text-end pt-3 pb-3">
          <button class="btn btn-primary" type="submit">Odbieram nagrodę &raquo;</button>
        </div>
      </div>
    </form>
  </div>
</div>

<script>
var timeout = new Date();
timeout.setTime(timeout.getTime() + <?= $result->timeout ?>000);
var timer = setInterval(function() {
  var remain = Math.round((timeout - (new Date()).getTime()) / 1000);
  if (remain <= 0) {
    clearInterval(timer);
    waiting();
    location.reload();
    return;
  }
  $("#timeout").html(remain);
}, 500);
</script>